/*
 * ConfigDialog.cpp
 *
 *  Created on: 04.05.2011
 *      Author: stefan.detter
 */

#include "ConfigDialog.h"

ConfigDialog::ConfigDialog()
	: m_infoEdit(0)
{
}

ConfigDialog::~ConfigDialog()
{
}

void ConfigDialog::setInfoEdit(QTextEdit* infoEdit)
{
	m_infoEdit = infoEdit;
}

void ConfigDialog::infoSet(const QString& text)
{
	if(!m_infoEdit)return;
	m_infoEdit->setText(text);
}

void ConfigDialog::infoSetProcessing(const QString& text)
{
	if(!m_infoEdit)return;
	m_infoEdit->setText(text);
	showProcessing();
}

void ConfigDialog::infoSetOK(const QString& text)
{
	if(!m_infoEdit)return;
	m_infoEdit->setText(text);
	showOK();
}

void ConfigDialog::infoSetError(const QString& text)
{
	if(!m_infoEdit)return;
	m_infoEdit->setText(text);
	showNOK();
}

void ConfigDialog::infoAppend(const QString& text)
{
	if(!m_infoEdit)return;
	m_infoEdit->append(text);
}


void ConfigDialog::handleError(QrfeGlobal::TMIResult result, const QString& text)
{
	if(!m_infoEdit)return;
	if(result == QrfeGlobal::TMI_OK)
	{
		showOK();
	}
	else if(result == QrfeGlobal::TMI_TAG_UNREACHABLE)
	{
		m_infoEdit->setText("-- " + text + " - ERROR -- \n Tag is not in the range of the reader...");
		showTagUnreachable();
	}
	else if(result == QrfeGlobal::TMI_WRONG_PASSW)
	{
		m_infoEdit->setText("-- " + text + " - ERROR -- \n Wrong password...");
		showWrongPassword();
	}
	else if(result == QrfeGlobal::TMI_MEM_OVERRUN)
	{
		m_infoEdit->setText("-- " + text + " - ERROR -- \n Memory overrun...");
		showMemoryOverrun();
	}
	else if(result == QrfeGlobal::TMI_MEM_LOCKED)
	{
		m_infoEdit->setText("-- " + text + " - ERROR -- \n Memory is locked, you must specify a access password...");
		showMemoryLocked();
	}
	else if(result == QrfeGlobal::TMI_INSUFFICIENT_POWER)
	{
		m_infoEdit->setText("-- " + text + " - ERROR -- \n Tag has insufficient power...");
		showInsufficentPower();
	}
	else{
		m_infoEdit->setText("-- " + text + " - ERROR --");
		showNOK();
	}

}

void ConfigDialog::clearInfo()
{
	if(!m_infoEdit)return;
	QPalette pal = m_infoEdit->palette();
	pal.setColor(QPalette::Base, QColor(Qt::white));
	m_infoEdit->setPalette(pal);
	m_infoEdit->clear();
	m_infoEdit->repaint();
}

void ConfigDialog::showProcessing()
{
	if(!m_infoEdit)return;
	QPalette pal = m_infoEdit->palette();
	pal.setColor(QPalette::Base, QColor(Qt::gray).lighter());
	m_infoEdit->setPalette(pal);
	m_infoEdit->repaint();
}

void ConfigDialog::showOK()
{
	if(!m_infoEdit)return;
	QPalette pal = m_infoEdit->palette();
	pal.setColor(QPalette::Base, QColor(Qt::green).lighter());
	m_infoEdit->setPalette(pal);
	m_infoEdit->repaint();
}

void ConfigDialog::showTagUnreachable()
{
	if(!m_infoEdit)return;
	QPalette pal = m_infoEdit->palette();
	pal.setColor(QPalette::Base, QColor(Qt::gray));
	m_infoEdit->setPalette(pal);
	m_infoEdit->repaint();
}

void ConfigDialog::showWrongPassword()
{
	if(!m_infoEdit)return;
	QPalette pal = m_infoEdit->palette();
	pal.setColor(QPalette::Base, QColor(Qt::darkRed));
	m_infoEdit->setPalette(pal);
	m_infoEdit->repaint();
}

void ConfigDialog::showMemoryOverrun()
{
	if(!m_infoEdit)return;
	QPalette pal = m_infoEdit->palette();
	pal.setColor(QPalette::Base, QColor(Qt::magenta).lighter());
	m_infoEdit->setPalette(pal);
	m_infoEdit->repaint();
}

void ConfigDialog::showMemoryLocked()
{
	if(!m_infoEdit)return;
	QPalette pal = m_infoEdit->palette();
	pal.setColor(QPalette::Base, QColor(Qt::cyan).lighter());
	m_infoEdit->setPalette(pal);
	m_infoEdit->repaint();
}

void ConfigDialog::showInsufficentPower()
{
	if(!m_infoEdit)return;
	QPalette pal = m_infoEdit->palette();
	pal.setColor(QPalette::Base, QColor(Qt::blue).lighter());
	m_infoEdit->setPalette(pal);
	m_infoEdit->repaint();
}

void ConfigDialog::showNOK()
{
	if(!m_infoEdit)return;
	QPalette pal = m_infoEdit->palette();
	pal.setColor(QPalette::Base, QColor(Qt::red).lighter());
	m_infoEdit->setPalette(pal);
	m_infoEdit->repaint();
}
